/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.html.renderer;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.html.UriContentResolver;
import icyllis.flexmark.html.UriContentResolverFactory;
import icyllis.flexmark.html.renderer.LinkResolverBasicContext;
import icyllis.flexmark.html.renderer.LinkStatus;
import icyllis.flexmark.html.renderer.ResolvedContent;
import icyllis.flexmark.html.renderer.ResolvedLink;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.dependency.LastDependent;
import icyllis.flexmark.util.misc.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class FileUriContentResolver
implements UriContentResolver {
    public FileUriContentResolver(LinkResolverBasicContext context) {
    }

    @Override
    @NotNull
    public ResolvedContent resolveContent(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedContent content) {
        String substring;
        File includedFile;
        String url;
        ResolvedLink resolvedLink = content.getResolvedLink();
        if (resolvedLink.getStatus() == LinkStatus.VALID && (url = resolvedLink.getUrl()).startsWith("file:/") && (includedFile = new File(substring = url.startsWith("file://") ? url.substring("file://".length()) : (File.separatorChar == '\\' ? url.substring("file:/".length()) : url.substring("file:".length())))).isFile() && includedFile.exists()) {
            try {
                return content.withContent(FileUtil.getFileContentBytesWithExceptions(includedFile)).withStatus(LinkStatus.VALID);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public static class Factory
    implements UriContentResolverFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return Collections.singleton(LastDependent.class);
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public UriContentResolver apply(@NotNull LinkResolverBasicContext context) {
            return new FileUriContentResolver(context);
        }
    }
}

